
<?php include ("../serive/samparka.php"); ?>

<?php
// Function to log errors
function logError($message) {
    file_put_contents('log.txt', date('Y-m-d H:i:s') . " - " . $message . "\n", FILE_APPEND);
}

// Log the callback data for debugging
logError("Received data: " . print_r($_GET, true));

// Extract callback data
$data = $_GET;
$orderNumber = $data['order_number'] ?? null;
$amount = $data['amount'] ?? null;
$status = $data['status'] ?? null;
$remark = $data['remark'] ?? null;

// Validate required parameters
if (!$orderNumber || !$amount || !$status) {
    logError("Error: Missing required parameters");
    exit;
}

function getRewardAmount($rechargeAmount) {
    $rewardTiers = [
        ['amount' => 100000, 'reward' => 7000],
        ['amount' => 50000, 'reward' => 3000],
        ['amount' => 10000, 'reward' => 900],
        ['amount' => 5000, 'reward' => 400],
        ['amount' => 3000, 'reward' => 300],
        ['amount' => 1000, 'reward' => 150],
        ['amount' => 500, 'reward' => 100],
        ['amount' => 300, 'reward' => 50]
    ];

    foreach ($rewardTiers as $tier) {
        if ($rechargeAmount >= $tier['amount']) {
            return $tier['reward'];
        }
    }
    return 0;
}

// Modify the order processing logic
if ($status === 'success') {
    $checkamt = mysqli_query($conn, "SELECT t.motta, t.balakedara, t.sthiti, 
        (SELECT COUNT(*) FROM thevani WHERE balakedara = t.balakedara AND sthiti = '1') as recharge_count,
        (SELECT code FROM shonu_subjects WHERE id = t.balakedara) as referrer_code
        FROM thevani t 
        WHERE t.dharavahi = '".$orderNumber."' AND t.sthiti = '0'");

    if (!$checkamt) {
        logError("Database query error: " . mysqli_error($conn));
        exit;
    }

    $checkamtrow = mysqli_num_rows($checkamt);

    if ($checkamtrow >= 1) {
        $checkamtar = mysqli_fetch_array($checkamt);
        $motta = $checkamtar['motta'];
        $shonuid = $checkamtar['balakedara'];
        $recharge_count = $checkamtar['recharge_count'];
        $referrer_code = $checkamtar['referrer_code'];

        // Update user's balance
        $nabikarana = "UPDATE shonu_kaichila 
                       SET motta = ROUND(motta + '".$motta."', 2) 
                       WHERE balakedara = '".$shonuid."'";
        
        if (!$conn->query($nabikarana)) {
            logError("Database update error: " . mysqli_error($conn));
            exit;
        }

        // If this is user's first recharge, process referral bonus
        if ($recharge_count == 0 && $referrer_code) {
            $reward_amount = getRewardAmount($motta);
            
            if ($reward_amount > 0) {
                // Get referrer's ID
                $referrer_query = "SELECT id FROM shonu_subjects WHERE owncode = '".$referrer_code."'";
                $referrer_result = $conn->query($referrer_query);
                
                if ($referrer_row = mysqli_fetch_array($referrer_result)) {
                    $referrer_id = $referrer_row['id'];
                    
                    // Update referrer's balance
                    $referrer_update = "UPDATE shonu_kaichila 
                                      SET motta = ROUND(motta + '".$reward_amount."', 2) 
                                      WHERE balakedara = '".$referrer_id."'";
                    
                    if (!$conn->query($referrer_update)) {
                        logError("Referral bonus update error: " . mysqli_error($conn));
                    } else {
                        // Log the referral bonus transaction in existing table
                        $bonus_log = mysqli_query($conn, "INSERT INTO vyavahara 
                            (balakedara, ketebida, prakara, ayoga, koduvavanu, tiarikala) 
                            VALUES 
                            ('".$referrer_id."', '".$reward_amount."', 'REFERRAL_BONUS', '".$reward_amount."', 
                             '".$shonuid."', '".date('Y-m-d H:i:s')."')");
                        
                        if (!$bonus_log) {
                            logError("Referral bonus log error: " . mysqli_error($conn));
                        }

                        // Insert into new separate referral bonus log table
                        $referral_log = mysqli_query($conn, "INSERT INTO referral_bonus_log 
                            (referrer_id, referee_id, bonus_amount, recharge_amount, created_at) 
                            VALUES 
                            ('".$referrer_id."', '".$shonuid."', '".$reward_amount."', '".$motta."', '".date('Y-m-d H:i:s')."')");
                        
                        if (!$referral_log) {
                            logError("Referral bonus separate log error: " . mysqli_error($conn));
                        }
                    }
                }
            }
        }

        // Update order status
        $sql2 = mysqli_query($conn, "UPDATE thevani SET sthiti = '1' WHERE dharavahi = '".$orderNumber."'");
        if (!$sql2) {
            logError("Order status update error: " . mysqli_error($conn));
            exit;
        }
    }
}

echo "OK";
exit;
?>